/*
 * Decompiled with CFR 0.152.
 */
package prog10082.exercises.oop;

public class Cat {
    private String name;
    private String breed;
    private boolean hungry = false;
    private final String[] names = new String[]{"Muffin", "Fluffy", "Dumpling", "Spot", "Whiskers", "Shadow", "Felix", "Tigger", "Smudge", "Simba", "Misty", "Sasha", "Milo", "Luna", "Molly", "Tom", "Morris", "Fritz", "Coco", "Cleo", "Puss", "Smokey", "Oscar", "Ginger", "Tibby", "Charlie", "Daisy", "Jasper", "Sooty", "Alfie", "Millie", "Bella", "Patches", "Pumpkin", "Maggie", "Oreo", "Sam", "Max", "Oliver", "Minka", "Maru", "Moritz", "Eva", "Lucy", "Sisko", "Lulu"};
    private final String[] breeds = new String[]{"Grey Tabby", "Void Kitty", "Orange Tabby", "Russian Blue", "Tawny Tabby", "Snowshoe", "Siamese", "Persian", "Manx", "British Shorthair", "Maine Coon", "American Shorthair", "Ragdoll", "Bengal", "White Domestic Shorthair", "Calico", "Abyssinian", "Scottish Fold", "Birman", "Burmese", "Japanese Bobtail", "Bombay", "Egyptian Mau", "Balinese", "Munchkin", "Savannah", "Ocicat", "Cornish Rex", "Chartreux"};
    private final String[] locns = new String[]{"on your shoe", "in your shoe", "in front of you", "in your bed", "on the folded laundry", "in your lap", "on the bath mat", "under your desk", "on your keyboard", "on your snack", "in your cup", "on your mouse", "on your desk", "under the table", "by the front door", "in front of your bedroom door", "in your closet", "on your favourite jeans", "in your sock drawer", "on your homework", "in the litter box", "in their dish", "on the TV remote", "on your chair", "in your slipper", "on the floor", "on your pillow", "in the bath tub", "on your open textbook", "in your hand"};

    public Cat() {
        this.name = this.names[(int)(Math.random() * (double)this.names.length)];
        this.breed = this.breeds[(int)(Math.random() * (double)this.breeds.length)];
    }

    public Cat(String name) {
        this.setName(name);
        this.breed = this.breeds[(int)(Math.random() * (double)this.breeds.length)];
    }

    public Cat(String name, String breed) {
        this.init(name, breed);
    }

    private void init(String name, String breed) {
        this.setName(name);
        this.setBreed(breed);
    }

    public void setName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Error: Cat name can't be empty.");
        }
        this.name = name;
    }

    private void setBreed(String breed) {
        if (breed == null || breed.trim().isEmpty()) {
            throw new IllegalArgumentException("Error: Cat breed can't be empty.");
        }
        this.breed = breed;
    }

    public String getName() {
        return this.name;
    }

    public String getBreed() {
        return this.breed;
    }

    public boolean isHungry() {
        return this.hungry;
    }

    public String feed() {
        boolean bl = this.hungry = this.hungry ? this.hungry : this.hungry();
        if (this.hungry) {
            String output = String.format("%s is eating happily.", this.name);
            this.hungry = this.vomit();
            return output + (this.hungry ? this.catVomit() : "");
        }
        return "Your cat isn't hungry.";
    }

    public String feed(String food) {
        boolean bl = this.hungry = this.hungry ? this.hungry : this.hungry();
        if (this.hungry) {
            String output = String.format("%s is eating %s.", this.name, food);
            this.hungry = this.vomit();
            return output + (this.hungry ? this.catVomit() : "");
        }
        return "Your cat isn't hungry right now.";
    }

    public String feed(int number, String food) {
        boolean bl = this.hungry = this.hungry ? this.hungry : this.hungry();
        if (this.hungry) {
            String output = String.format("%s eagerly eats %d %s.", this.name, number, food);
            this.hungry = this.vomit();
            return output + (this.hungry ? this.catVomit() : "");
        }
        return "Your cat isn't hungry.";
    }

    private boolean vomit() {
        return (int)(Math.random() * 100.0) < 5;
    }

    private boolean hungry() {
        return Math.random() < 0.65;
    }

    private String catVomit() {
        return String.format("\n%s vomits %s and is now hungry again.", this.name, this.locns[(int)(Math.random() * (double)this.locns.length)]);
    }

    public String catInfo() {
        String output = String.format("Cat Name: %s\nBreed: %s", this.name, this.breed);
        return output + (this.hungry ? "\nYour cat is hungry." : "");
    }
}

